<?php
require_once 'config/config.php';

if (!isLoggedIn()) {
    redirect(SITE_URL . '/login.php');
}

$pageTitle = "My Orders | " . SITE_NAME;
require_once 'includes/header.php';
?>

<section class="py-12 min-h-screen bg-gray-50">
    <div class="container mx-auto px-4">
        <h1 class="text-4xl font-display font-bold text-gray-900 mb-8">My Orders</h1>

        <div class="bg-white rounded-xl shadow-md p-8 text-center">
            <i class="fas fa-shopping-bag text-gray-400 text-6xl mb-4"></i>
            <h2 class="text-2xl font-display font-bold text-gray-900 mb-2">No Orders Yet</h2>
            <p class="text-gray-600 mb-6">When you place orders, they will appear here</p>
            <a href="<?php echo SITE_URL; ?>/products.php" class="btn-primary">
                Start Shopping
            </a>
        </div>
    </div>
</section>

<?php require_once 'includes/footer.php'; ?>
