<?php
require_once 'config/config.php';

if (isLoggedIn()) {
    redirect(SITE_URL . '/account.php');
}

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $emailOrUsername = sanitize($_POST['email'] ?? '');
    $password = $_POST['password'] ?? '';

    if ($emailOrUsername && $password) {
        $conn = getDBConnection();
        // Check if input is email or username
        $stmt = $conn->prepare("SELECT id, name, email, password, role FROM users WHERE email = ? OR name = ?");
        $stmt->bind_param("ss", $emailOrUsername, $emailOrUsername);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result->num_rows > 0) {
            $user = $result->fetch_assoc();
            if (password_verify($password, $user['password'])) {
                $_SESSION['user_id'] = $user['id'];
                $_SESSION['user_name'] = $user['name'];
                $_SESSION['user_email'] = $user['email'];
                $_SESSION['user_role'] = $user['role'];

                // Merge cart from session to user
                $sessionId = $_SESSION['cart_session_id'] ?? '';
                if ($sessionId) {
                    $mergeStmt = $conn->prepare("UPDATE cart SET user_id = ?, session_id = NULL WHERE session_id = ?");
                    $mergeStmt->bind_param("is", $user['id'], $sessionId);
                    $mergeStmt->execute();
                    $mergeStmt->close();
                }

                $stmt->close();
                closeDBConnection($conn);
                
                // Redirect admins to admin panel, customers to account page
                if ($user['role'] === 'admin') {
                    redirect(SITE_URL . '/admin/index.php');
                } else {
                    redirect(SITE_URL . '/account.php');
                }
            } else {
                $error = 'Invalid email or password';
            }
        } else {
            $error = 'Invalid email or password';
        }
        $stmt->close();
        closeDBConnection($conn);
    } else {
        $error = 'Please fill in all fields';
    }
}

$pageTitle = "Login | " . SITE_NAME;
require_once 'includes/header.php';
?>

<section class="py-20 min-h-screen bg-gray-50">
    <div class="container mx-auto px-4">
        <div class="max-w-md mx-auto">
            <div class="bg-white rounded-2xl shadow-xl p-8">
                <div class="text-center mb-8">
                    <h1 class="text-3xl font-display font-bold text-gray-900 mb-2">Welcome Back</h1>
                    <p class="text-gray-600"><?php echo isset($_GET['redirect']) && $_GET['redirect'] === 'admin' ? 'Login with admin credentials' : 'Login to your account'; ?></p>
                </div>

                <?php if (isset($_GET['redirect']) && $_GET['redirect'] === 'admin'): ?>
                    <div class="bg-primary-50 border border-primary-200 text-primary-700 px-4 py-3 rounded-lg mb-6">
                        <i class="fas fa-shield-alt mr-2"></i>Admin access required. Please login with admin credentials.
                    </div>
                <?php endif; ?>

                <?php if ($error): ?>
                    <div class="bg-red-50 border border-red-200 text-red-700 px-4 py-3 rounded-lg mb-6">
                        <i class="fas fa-exclamation-circle mr-2"></i><?php echo $error; ?>
                    </div>
                <?php endif; ?>

                <form method="POST" action="">
                    <div class="mb-4">
                        <label class="block text-gray-700 font-semibold mb-2"><?php echo isset($_GET['redirect']) && $_GET['redirect'] === 'admin' ? 'Username or Email' : 'Email Address'; ?></label>
                        <input type="text" name="email" required 
                               class="input-field" placeholder="<?php echo isset($_GET['redirect']) && $_GET['redirect'] === 'admin' ? 'Admin or admin@admin.com' : 'your@email.com'; ?>"
                               value="<?php echo htmlspecialchars($_POST['email'] ?? ''); ?>">
                    </div>

                    <div class="mb-6">
                        <label class="block text-gray-700 font-semibold mb-2">Password</label>
                        <input type="password" name="password" required 
                               class="input-field" placeholder="Enter your password">
                    </div>

                    <div class="flex items-center justify-between mb-6">
                        <label class="flex items-center">
                            <input type="checkbox" class="mr-2 rounded">
                            <span class="text-sm text-gray-600">Remember me</span>
                        </label>
                        <a href="#" class="text-sm text-primary-600 hover:text-primary-700">Forgot password?</a>
                    </div>

                    <button type="submit" class="btn-primary w-full text-lg">
                        <i class="fas fa-sign-in-alt mr-2"></i>Login
                    </button>
                </form>

                <div class="mt-6 text-center">
                    <p class="text-gray-600">
                        Don't have an account?
                        <a href="<?php echo SITE_URL; ?>/register.php" class="text-primary-600 hover:text-primary-700 font-semibold">
                            Register here
                        </a>
                    </p>
                </div>
            </div>
        </div>
    </div>
</section>

<?php require_once 'includes/footer.php'; ?>
