<?php
require_once __DIR__ . '/config/config.php';

// Prevent caching
header("Cache-Control: no-cache, must-revalidate");
header("Expires: Sat, 26 Jul 1997 05:00:00 GMT");
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Configuration Check - <?php echo SITE_NAME; ?></title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { 
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding: 20px;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        .container {
            background: white;
            border-radius: 16px;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3);
            max-width: 800px;
            width: 100%;
            padding: 40px;
        }
        h1 { 
            color: #2d3748; 
            margin-bottom: 10px;
            font-size: 28px;
        }
        .subtitle {
            color: #718096;
            margin-bottom: 30px;
            font-size: 14px;
        }
        .check-item {
            padding: 20px;
            margin: 15px 0;
            border-radius: 8px;
            background: #f7fafc;
            border-left: 4px solid #4299e1;
        }
        .check-item.success { border-left-color: #48bb78; background: #f0fff4; }
        .check-item.error { border-left-color: #f56565; background: #fff5f5; }
        .check-item h3 {
            color: #2d3748;
            margin-bottom: 8px;
            font-size: 16px;
        }
        .check-item p {
            color: #4a5568;
            font-size: 14px;
            line-height: 1.6;
        }
        .value {
            background: white;
            padding: 8px 12px;
            border-radius: 4px;
            margin-top: 8px;
            font-family: 'Courier New', monospace;
            font-size: 13px;
            color: #2d3748;
            border: 1px solid #e2e8f0;
        }
        .success-icon { color: #48bb78; }
        .error-icon { color: #f56565; }
        .info-icon { color: #4299e1; }
        .icon { margin-right: 8px; }
        .nav-button {
            display: inline-block;
            padding: 12px 24px;
            background: #667eea;
            color: white;
            text-decoration: none;
            border-radius: 8px;
            font-weight: 600;
            margin-top: 20px;
            transition: all 0.3s;
        }
        .nav-button:hover {
            background: #5568d3;
            transform: translateY(-2px);
            box-shadow: 0 10px 20px rgba(102, 126, 234, 0.3);
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>🔧 Configuration Check</h1>
        <p class="subtitle">Verifying your website configuration and assets</p>

        <?php
        // Check CSS file
        $cssPath = __DIR__ . '/assets/css/output.css';
        $cssExists = file_exists($cssPath);
        $cssSize = $cssExists ? filesize($cssPath) : 0;
        ?>
        <div class="check-item <?php echo $cssExists && $cssSize > 1000 ? 'success' : 'error'; ?>">
            <h3>
                <span class="icon"><?php echo $cssExists && $cssSize > 1000 ? '✅' : '❌'; ?></span>
                CSS File Check
            </h3>
            <p>
                Status: <strong><?php echo $cssExists ? 'Found' : 'Not Found'; ?></strong>
                <?php if ($cssExists): ?>
                    | Size: <strong><?php echo round($cssSize / 1024, 2); ?> KB</strong>
                <?php endif; ?>
            </p>
            <div class="value">Path: <?php echo $cssPath; ?></div>
            <?php if ($cssExists && $cssSize < 1000): ?>
                <p style="color: #f56565; margin-top: 8px;">⚠️ CSS file seems too small. Run: <code>npm run build</code></p>
            <?php endif; ?>
        </div>

        <div class="check-item success">
            <h3>
                <span class="icon">✅</span>
                Site URL Configuration
            </h3>
            <p>Your site URL is automatically detected and configured correctly.</p>
            <div class="value">SITE_URL: <?php echo SITE_URL; ?></div>
        </div>

        <div class="check-item success">
            <h3>
                <span class="icon">✅</span>
                Asset URL Generation
            </h3>
            <p>Dynamic asset URLs are working correctly from any directory.</p>
            <div class="value">CSS URL: <?php echo assetUrl('assets/css/output.css'); ?></div>
            <div class="value" style="margin-top: 4px;">Base Path: <?php echo getBasePath(); ?></div>
        </div>

        <?php
        // Check database connection
        try {
            $conn = getDBConnection();
            $dbConnected = true;
            $dbName = DB_NAME;
            closeDBConnection($conn);
        } catch (Exception $e) {
            $dbConnected = false;
            $dbError = $e->getMessage();
        }
        ?>
        <div class="check-item <?php echo $dbConnected ? 'success' : 'error'; ?>">
            <h3>
                <span class="icon"><?php echo $dbConnected ? '✅' : '❌'; ?></span>
                Database Connection
            </h3>
            <p>
                Status: <strong><?php echo $dbConnected ? 'Connected' : 'Failed'; ?></strong>
                <?php if ($dbConnected): ?>
                    | Database: <strong><?php echo $dbName; ?></strong>
                <?php endif; ?>
            </p>
            <?php if (!$dbConnected): ?>
                <div class="value" style="color: #f56565;"><?php echo $dbError; ?></div>
            <?php endif; ?>
        </div>

        <?php
        // Check uploads directory
        $uploadsDir = __DIR__ . '/uploads/products';
        $uploadsExists = is_dir($uploadsDir);
        $uploadsWritable = $uploadsExists && is_writable($uploadsDir);
        ?>
        <div class="check-item <?php echo $uploadsWritable ? 'success' : 'error'; ?>">
            <h3>
                <span class="icon"><?php echo $uploadsWritable ? '✅' : '❌'; ?></span>
                Uploads Directory
            </h3>
            <p>
                Status: <strong><?php echo $uploadsExists ? ($uploadsWritable ? 'Writable' : 'Not Writable') : 'Not Found'; ?></strong>
            </p>
            <div class="value"><?php echo $uploadsDir; ?></div>
            <?php if (!$uploadsWritable): ?>
                <p style="color: #f56565; margin-top: 8px;">⚠️ Create the directory or set permissions to 755</p>
            <?php endif; ?>
        </div>

        <div class="check-item success">
            <h3>
                <span class="icon">ℹ️</span>
                Server Information
            </h3>
            <p>Current server details for debugging.</p>
            <div class="value">PHP Version: <?php echo phpversion(); ?></div>
            <div class="value" style="margin-top: 4px;">Server: <?php echo $_SERVER['SERVER_SOFTWARE'] ?? 'Unknown'; ?></div>
            <div class="value" style="margin-top: 4px;">Host: <?php echo $_SERVER['HTTP_HOST'] ?? 'Unknown'; ?></div>
            <div class="value" style="margin-top: 4px;">Protocol: <?php echo (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'HTTPS' : 'HTTP'; ?></div>
        </div>

        <div style="text-align: center; margin-top: 30px;">
            <a href="<?php echo SITE_URL; ?>/index.php" class="nav-button">🏠 Go to Homepage</a>
            <a href="<?php echo SITE_URL; ?>/products.php" class="nav-button">🛍️ View Products</a>
        </div>
    </div>
</body>
</html>
