<?php
require_once __DIR__ . '/../config/config.php';

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Invalid request method']);
    exit;
}

$input = json_decode(file_get_contents('php://input'), true);
$cartId = isset($input['cart_id']) ? intval($input['cart_id']) : 0;
$quantity = isset($input['quantity']) ? intval($input['quantity']) : 0;
$productId = isset($input['product_id']) ? intval($input['product_id']) : 0;

if ($cartId <= 0 || $quantity < 0) {
    echo json_encode(['success' => false, 'message' => 'Invalid data']);
    exit;
}

$conn = getDBConnection();

// Check stock
$stockStmt = $conn->prepare("SELECT stock_quantity FROM products WHERE id = ?");
$stockStmt->bind_param("i", $productId);
$stockStmt->execute();
$stockResult = $stockStmt->get_result();
$stock = $stockResult->fetch_assoc();
$stockStmt->close();

if (!$stock || $stock['stock_quantity'] < $quantity) {
    closeDBConnection($conn);
    echo json_encode(['success' => false, 'message' => 'Insufficient stock']);
    exit;
}

// Update cart
$stmt = $conn->prepare("UPDATE cart SET quantity = ? WHERE id = ?");
$stmt->bind_param("ii", $quantity, $cartId);
$stmt->execute();
$stmt->close();
closeDBConnection($conn);

echo json_encode(['success' => true]);
