<?php
if (!defined('SITE_URL')) {
    require_once __DIR__ . '/../config/config.php';
}

$links = [
    'dashboard' => [
        'label' => 'Dashboard',
        'href' => SITE_URL . '/admin/index.php',
        'icon' => 'fa-chart-line',
    ],
    'products' => [
        'label' => 'Products',
        'href' => SITE_URL . '/admin/products.php',
        'icon' => 'fa-boxes-stacked',
    ],
    'categories' => [
        'label' => 'Categories',
        'href' => SITE_URL . '/admin/categories.php',
        'icon' => 'fa-tags',
    ],
    'orders' => [
        'label' => 'Orders',
        'href' => SITE_URL . '/admin/orders.php',
        'icon' => 'fa-receipt',
    ],
    'customers' => [
        'label' => 'Customers',
        'href' => SITE_URL . '/admin/customers.php',
        'icon' => 'fa-users',
    ],
    'hero-banners' => [
        'label' => 'Hero Banners',
        'href' => SITE_URL . '/admin/hero-banners.php',
        'icon' => 'fa-image',
    ],
];

?>
<div class="bg-white rounded-xl shadow-sm border border-gray-200 mb-8">
    <nav class="flex flex-wrap gap-2 p-4">
        <?php foreach ($links as $key => $link): 
            $isActive = ($activePage ?? '') === $key;
        ?>
            <a href="<?php echo $link['href']; ?>"
               class="inline-flex items-center gap-2 px-4 py-2 rounded-lg text-sm font-medium transition-colors <?php echo $isActive ? 'bg-primary-100 text-primary-700 border border-primary-200' : 'text-gray-600 hover:text-primary-600 hover:bg-gray-100'; ?>">
                <i class="fas <?php echo $link['icon']; ?>"></i>
                <?php echo $link['label']; ?>
            </a>
        <?php endforeach; ?>
    </nav>
</div>
