<?php
require_once 'config/config.php';
$pageTitle = "About Us | " . SITE_NAME;
require_once 'includes/header.php';
?>

<section class="py-20 bg-gradient-to-br from-primary-50 to-primary-100">
    <div class="container mx-auto px-4 text-center">
        <h1 class="text-5xl md:text-6xl font-display font-bold text-gray-900 mb-6">
            About Our Natural Beauty Mission
        </h1>
        <p class="text-xl text-gray-600 max-w-3xl mx-auto">
            Committed to bringing you the finest organic skincare products that are kind to your skin and the planet
        </p>
    </div>
</section>

<section class="py-20">
    <div class="container mx-auto px-4">
        <div class="grid md:grid-cols-2 gap-12 items-center mb-20">
            <div>
                <h2 class="text-4xl font-display font-bold text-gray-900 mb-6">Our Story</h2>
                <p class="text-gray-600 leading-relaxed mb-4">
                    Founded with a passion for natural beauty and sustainable practices, our journey began with a simple belief: skincare should be both effective and ethical. We source only the finest organic ingredients from sustainable farms around the world.
                </p>
                <p class="text-gray-600 leading-relaxed mb-4">
                    Every product we create is crafted with care, using traditional methods combined with modern science to ensure maximum efficacy. We're committed to transparency, sustainability, and providing you with products you can trust.
                </p>
                <p class="text-gray-600 leading-relaxed">
                    Our mission extends beyond skincare - with every purchase, we plant a tree, contributing to reforestation efforts worldwide. Together, we're making beauty sustainable.
                </p>
            </div>
            <div class="relative">
                <img src="https://images.unsplash.com/photo-1556228720-195a672e8a03?w=600&h=700&fit=crop" 
                     alt="Our Story" class="rounded-2xl shadow-2xl">
            </div>
        </div>

        <div class="grid md:grid-cols-3 gap-8 mb-20">
            <div class="text-center">
                <div class="bg-primary-100 w-20 h-20 rounded-full flex items-center justify-center mx-auto mb-4">
                    <i class="fas fa-leaf text-primary-600 text-3xl"></i>
                </div>
                <h3 class="text-2xl font-display font-bold text-gray-900 mb-3">100% Organic</h3>
                <p class="text-gray-600">
                    Certified organic ingredients sourced from sustainable farms. No harsh chemicals or synthetic additives.
                </p>
            </div>

            <div class="text-center">
                <div class="bg-primary-100 w-20 h-20 rounded-full flex items-center justify-center mx-auto mb-4">
                    <i class="fas fa-heart text-primary-600 text-3xl"></i>
                </div>
                <h3 class="text-2xl font-display font-bold text-gray-900 mb-3">Cruelty-Free</h3>
                <p class="text-gray-600">
                    Proudly vegan and never tested on animals. Beauty without compromise to our ethical values.
                </p>
            </div>

            <div class="text-center">
                <div class="bg-primary-100 w-20 h-20 rounded-full flex items-center justify-center mx-auto mb-4">
                    <i class="fas fa-globe text-primary-600 text-3xl"></i>
                </div>
                <h3 class="text-2xl font-display font-bold text-gray-900 mb-3">Eco-Friendly</h3>
                <p class="text-gray-600">
                    Sustainable packaging and reforestation initiatives. One product sold, one tree planted.
                </p>
            </div>
        </div>

        <div class="bg-primary-50 rounded-3xl p-12 text-center">
            <h2 class="text-4xl font-display font-bold text-gray-900 mb-4">Join Our Green Beauty Movement</h2>
            <p class="text-xl text-gray-600 mb-8 max-w-2xl mx-auto">
                Experience the difference that truly natural, organic skincare can make for your skin and the environment
            </p>
            <a href="<?php echo SITE_URL; ?>/products.php" class="btn-primary text-lg">
                Shop Our Collection
            </a>
        </div>
    </div>
</section>

<?php require_once 'includes/footer.php'; ?>
