# Organic Skincare E-commerce Website

A modern, responsive e-commerce website built with PHP and Tailwind CSS for organic skincare products.

## Features

- 🌿 Modern and clean design
- 📱 Fully responsive with mobile bottom navigation
- 🛒 Shopping cart functionality
- 👤 User authentication (login/register)
- 🔍 Product search and filtering
- 📦 Product categories
- ⭐ Featured and new arrival products
- 💳 Checkout system (basic)
- 📊 Admin panel ready
- 🎨 Custom Tailwind CSS styling

## Technology Stack

- **Backend:** PHP 8.x
- **Database:** MySQL/MariaDB
- **Frontend:** Tailwind CSS 3.x, HTML5, JavaScript
- **Icons:** Font Awesome 6.x
- **Fonts:** Google Fonts (Inter, Playfair Display)

## Installation

### Prerequisites

- XAMPP (or any PHP development environment)
- Node.js and npm (for Tailwind CSS)
- Web browser

### Step 1: Database Setup

1. Start XAMPP and ensure Apache and MySQL are running
2. Open phpMyAdmin (http://localhost/phpmyadmin)
3. Import the database:
   ```sql
   mysql -u root -p < database.sql
   ```
   Or manually run the `database.sql` file in phpMyAdmin

### Step 2: Configure Database Connection

The database configuration is already set in `config/database.php`:
- Host: localhost
- User: root
- Password: (empty)
- Database: skincare_shop

Update these if your setup is different.

### Step 3: Install Tailwind CSS

1. Navigate to the project directory:
   ```bash
   cd /Applications/XAMPP/xamppfiles/htdocs/skin
   ```

2. Install npm dependencies:
   ```bash
   npm install
   ```

3. Build Tailwind CSS:
   ```bash
   npm run build:css
   ```

   Or for development with watch mode:
   ```bash
   npm run watch:css
   ```

### Step 4: Create Uploads Directory

Create the uploads directory for product images:
```bash
mkdir -p uploads/products
chmod 755 uploads
chmod 755 uploads/products
```

### Step 5: Access the Website

Open your browser and navigate to:
```
http://localhost/skin
```

## Default Login Credentials

### Admin Account
- Email: admin@skincare.com
- Password: admin123

## Project Structure

```
skin/
├── api/                    # API endpoints
│   ├── add-to-cart.php
│   ├── cart-count.php
│   ├── update-cart.php
│   └── remove-from-cart.php
├── assets/
│   └── css/
│       ├── input.css       # Tailwind source
│       └── output.css      # Compiled CSS
├── config/
│   ├── config.php          # Main configuration
│   └── database.php        # Database connection
├── includes/
│   ├── header.php          # Header template
│   └── footer.php          # Footer template
├── uploads/
│   └── products/           # Product images
├── index.php               # Homepage
├── products.php            # Product listing
├── product.php             # Product detail
├── cart.php                # Shopping cart
├── checkout.php            # Checkout page
├── login.php               # User login
├── register.php            # User registration
├── account.php             # User account
├── about.php               # About page
├── contact.php             # Contact page
├── database.sql            # Database schema
├── tailwind.config.js      # Tailwind configuration
└── package.json            # Node dependencies
```

## Features Breakdown

### Frontend
- Responsive navigation with mobile bottom menu
- Hero section with call-to-action
- Product grid with filtering and sorting
- Product detail pages with image gallery
- Shopping cart with quantity management
- User authentication forms
- Account dashboard
- Category browsing

### Backend
- User authentication and session management
- Shopping cart (session and user-based)
- Product management (database)
- Order system (ready for expansion)
- Dynamic product listings with pagination
- Search and filter functionality

## Customization

### Colors
Edit `tailwind.config.js` to change the color scheme:
```javascript
colors: {
  primary: { /* Your primary colors */ },
  accent: { /* Your accent colors */ }
}
```

### Site Information
Edit `config/config.php` to update:
- Site name
- Site URL
- Currency symbol
- Free shipping threshold

### Sample Data
The database includes:
- 6 product categories
- 12 sample products
- 1 admin user

## Mobile Features

- Bottom navigation bar with icons
- Touch-friendly interface
- Responsive images
- Optimized layouts for small screens
- Safe area support for notched devices

## Browser Support

- Chrome (latest)
- Firefox (latest)
- Safari (latest)
- Edge (latest)
- Mobile browsers (iOS Safari, Chrome Mobile)

## Development

### Watch Mode
For active development, use watch mode:
```bash
npm run watch:css
```

This will automatically rebuild CSS when you make changes to PHP or CSS files.

### Adding New Products
1. Log in as admin
2. Use phpMyAdmin to add products to the `products` table
3. Add product images to `uploads/products/`
4. Link images in the `product_images` table

## Security Notes

- Change the default admin password
- Update database credentials
- Enable HTTPS in production
- Implement CSRF protection
- Add input validation and sanitization
- Use prepared statements (already implemented)

## Future Enhancements

- [ ] Complete checkout with payment gateway
- [ ] Order management system
- [ ] Admin panel for product management
- [ ] Email notifications
- [ ] Wishlist functionality
- [ ] Product reviews and ratings
- [ ] Advanced search with filters
- [ ] Coupon/discount system
- [ ] Inventory management
- [ ] Multi-language support

## Support

For issues or questions, please create an issue in the project repository.

## License

This project is open-source and available under the MIT License.

---

**Made with 💚 for beautiful, natural skin**
