# Quick Installation Guide

Follow these steps to get your skincare e-commerce website up and running.

## Prerequisites ✅

- XAMPP installed (or similar PHP/MySQL environment)
- Node.js and npm installed
- A web browser

## Step-by-Step Installation

### 1. Start XAMPP

Open XAMPP Control Panel and start:
- ✅ Apache
- ✅ MySQL

### 2. Import Database

**Option A: Using phpMyAdmin**
1. Open http://localhost/phpmyadmin in your browser
2. Click "New" to create a new database (or the import tab)
3. Click "Import" tab
4. Click "Choose File" and select `database.sql`
5. Click "Go" to import

**Option B: Using Command Line**
```bash
mysql -u root -p < database.sql
# Press Enter when prompted for password (default is empty)
```

### 3. Install Dependencies

Open Terminal/Command Prompt and navigate to the project:

```bash
cd /Applications/XAMPP/xamppfiles/htdocs/skin
npm install
npm run build:css
```

### 4. Set Permissions (Mac/Linux)

```bash
chmod -R 755 uploads/
```

### 5. Access Your Website

Open your browser and visit:
```
http://localhost/skin
```

## Default Login Credentials 🔑

**Admin Account:**
- Email: `admin@skincare.com`
- Password: `admin123`

**⚠️ Important:** Change this password after first login!

## Troubleshooting 🔧

### Database Connection Error
- Verify MySQL is running in XAMPP
- Check database credentials in `config/database.php`
- Ensure database `skincare_shop` exists

### CSS Not Loading
```bash
npm run build:css
```

### Images Not Showing
- Check that `uploads/products/` directory exists
- Verify directory permissions (755)
- Sample products use fallback images from Unsplash

### Page Not Found
- Ensure Apache is running
- Check that project is in `htdocs/skin` directory
- Verify `.htaccess` file exists

### Port Already in Use
- Check if another application is using port 80
- Change Apache port in XAMPP settings
- Update SITE_URL in `config/config.php`

## Next Steps 🚀

1. **Change Admin Password**
   - Login with default credentials
   - Update password in account settings

2. **Add Product Images**
   - Place images in `uploads/products/`
   - Update database entries

3. **Customize Branding**
   - Edit `config/config.php` for site name
   - Modify colors in `tailwind.config.js`
   - Rebuild CSS: `npm run build:css`

4. **Test Functionality**
   - Browse products
   - Add items to cart
   - Create customer account
   - Test checkout flow

## Features to Explore 🌟

- ✅ Responsive design with mobile bottom menu
- ✅ Product filtering and search
- ✅ Shopping cart
- ✅ User authentication
- ✅ Product categories
- ✅ Featured products
- ✅ New arrivals section

## Need Help? 💬

Check the main README.md for detailed documentation and feature list.

## Development Mode 👨‍💻

For active development with auto-refresh CSS:

```bash
npm run watch:css
```

Keep this running in a separate terminal while you develop.

---

**Happy Selling! 🌿💚**
