<?php
http_response_code(404);
require_once 'config/config.php';
$pageTitle = "Page Not Found | " . SITE_NAME;

// Get popular categories dynamically
$conn = getDBConnection();
$categories = $conn->query("SELECT name, slug FROM categories ORDER BY display_order ASC LIMIT 6");

require_once 'includes/header.php';
?>

<section class="py-20 min-h-screen bg-gray-50 flex items-center">
    <div class="container mx-auto px-4 text-center">
        <div class="max-w-2xl mx-auto">
            <div class="text-primary-600 text-9xl font-bold mb-4">404</div>
            <h1 class="text-4xl md:text-5xl font-display font-bold text-gray-900 mb-4">
                Page Not Found
            </h1>
            <p class="text-xl text-gray-600 mb-8">
                Oops! The page you're looking for doesn't exist. It might have been moved or deleted.
            </p>
            <div class="flex flex-col sm:flex-row gap-4 justify-center">
                <a href="<?php echo SITE_URL; ?>/index.php" class="btn-primary">
                    <i class="fas fa-home mr-2"></i>Go Home
                </a>
                <a href="<?php echo SITE_URL; ?>/products.php" class="btn-outline">
                    <i class="fas fa-shopping-bag mr-2"></i>Shop Products
                </a>
            </div>
            
            <div class="mt-12">
                <p class="text-gray-600 mb-4">Popular categories:</p>
                <div class="flex flex-wrap justify-center gap-3">
                    <?php while ($category = $categories->fetch_assoc()): ?>
                        <a href="<?php echo SITE_URL; ?>/products.php?category=<?php echo htmlspecialchars($category['slug']); ?>" 
                           class="badge bg-primary-100 text-primary-700 hover:bg-primary-200 transition px-4 py-2 rounded-full">
                            <?php echo htmlspecialchars($category['name']); ?>
                        </a>
                    <?php endwhile; ?>
                </div>
            </div>
        </div>
    </div>
</section>

<?php 
closeDBConnection($conn);
require_once 'includes/footer.php'; 
?>
