<?php
require_once __DIR__ . '/../config/config.php';

if (!isLoggedIn()) {
    // Not logged in - redirect to login
    $_SESSION['admin_redirect'] = true;
    redirect(SITE_URL . '/login.php?redirect=admin');
} elseif (!isAdmin()) {
    // Logged in but not admin - show error
    redirect(SITE_URL . '/index.php');
}

$pageTitle = "Admin Dashboard | " . SITE_NAME;
require_once __DIR__ . '/../includes/header.php';
require_once __DIR__ . '/admin_nav.php';

$conn = getDBConnection();

// Get statistics
$totalProducts = $conn->query("SELECT COUNT(*) as count FROM products")->fetch_assoc()['count'];
$totalOrders = $conn->query("SELECT COUNT(*) as count FROM orders")->fetch_assoc()['count'];
$totalUsers = $conn->query("SELECT COUNT(*) as count FROM users WHERE role = 'customer'")->fetch_assoc()['count'];
$totalRevenue = $conn->query("SELECT SUM(total_amount) as total FROM orders WHERE payment_status = 'paid'")->fetch_assoc()['total'] ?? 0;

// Get recent orders
$recentOrders = $conn->query("
    SELECT o.*, u.name as user_name 
    FROM orders o 
    LEFT JOIN users u ON o.user_id = u.id 
    ORDER BY o.created_at DESC 
    LIMIT 10
");

closeDBConnection($conn);
?>

<section class="py-12 min-h-screen bg-gray-50">
    <div class="container mx-auto px-4">
        <div class="flex justify-between items-center mb-8">
            <h1 class="text-4xl font-display font-bold text-gray-900">Admin Dashboard</h1>
            <a href="<?php echo SITE_URL; ?>/index.php" class="btn-outline">
                <i class="fas fa-home mr-2"></i>Back to Site
            </a>
        </div>

        <!-- Statistics Cards -->
        <div class="grid md:grid-cols-4 gap-6 mb-8">
            <div class="bg-white rounded-xl shadow-md p-6">
                <div class="flex items-center justify-between mb-2">
                    <div class="bg-blue-100 w-12 h-12 rounded-full flex items-center justify-center">
                        <i class="fas fa-box text-blue-600 text-xl"></i>
                    </div>
                    <span class="text-sm text-gray-500">Total</span>
                </div>
                <h3 class="text-3xl font-bold text-gray-900 mb-1"><?php echo $totalProducts; ?></h3>
                <p class="text-gray-600">Products</p>
            </div>

            <div class="bg-white rounded-xl shadow-md p-6">
                <div class="flex items-center justify-between mb-2">
                    <div class="bg-green-100 w-12 h-12 rounded-full flex items-center justify-center">
                        <i class="fas fa-shopping-cart text-green-600 text-xl"></i>
                    </div>
                    <span class="text-sm text-gray-500">Total</span>
                </div>
                <h3 class="text-3xl font-bold text-gray-900 mb-1"><?php echo $totalOrders; ?></h3>
                <p class="text-gray-600">Orders</p>
            </div>

            <div class="bg-white rounded-xl shadow-md p-6">
                <div class="flex items-center justify-between mb-2">
                    <div class="bg-purple-100 w-12 h-12 rounded-full flex items-center justify-center">
                        <i class="fas fa-users text-purple-600 text-xl"></i>
                    </div>
                    <span class="text-sm text-gray-500">Total</span>
                </div>
                <h3 class="text-3xl font-bold text-gray-900 mb-1"><?php echo $totalUsers; ?></h3>
                <p class="text-gray-600">Customers</p>
            </div>

            <div class="bg-white rounded-xl shadow-md p-6">
                <div class="flex items-center justify-between mb-2">
                    <div class="bg-yellow-100 w-12 h-12 rounded-full flex items-center justify-center">
                        <i class="fas fa-dollar-sign text-yellow-600 text-xl"></i>
                    </div>
                    <span class="text-sm text-gray-500">Total</span>
                </div>
                <h3 class="text-3xl font-bold text-gray-900 mb-1"><?php echo formatCurrency($totalRevenue); ?></h3>
                <p class="text-gray-600">Revenue</p>
            </div>
        </div>

        <!-- Quick Actions -->
        <div class="bg-white rounded-xl shadow-md p-6 mb-8">
            <h2 class="text-2xl font-display font-bold text-gray-900 mb-6">Quick Actions</h2>
            <div class="grid md:grid-cols-4 gap-4">
                <a href="<?php echo SITE_URL; ?>/admin/products.php" class="btn-primary text-center">
                    <i class="fas fa-plus mr-2"></i>Add Product
                </a>
                <a href="<?php echo SITE_URL; ?>/admin/products.php" class="btn-outline text-center">
                    <i class="fas fa-list mr-2"></i>Manage Products
                </a>
                <a href="<?php echo SITE_URL; ?>/admin/orders.php" class="btn-outline text-center">
                    <i class="fas fa-shopping-bag mr-2"></i>View Orders
                </a>
                <a href="<?php echo SITE_URL; ?>/admin/customers.php" class="btn-outline text-center">
                    <i class="fas fa-users mr-2"></i>Manage Customers
                </a>
            </div>
        </div>

        <!-- Recent Orders -->
        <div class="bg-white rounded-xl shadow-md p-6">
            <h2 class="text-2xl font-display font-bold text-gray-900 mb-6">Recent Orders</h2>
            
            <?php if ($recentOrders->num_rows > 0): ?>
                <div class="overflow-x-auto">
                    <table class="w-full">
                        <thead class="bg-gray-50">
                            <tr>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Order #</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Customer</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Date</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Total</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Status</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Actions</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-200">
                            <?php while ($order = $recentOrders->fetch_assoc()): ?>
                                <tr class="hover:bg-gray-50">
                                    <td class="px-6 py-4 whitespace-nowrap font-medium">
                                        <?php echo htmlspecialchars($order['order_number']); ?>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <?php echo htmlspecialchars($order['user_name'] ?? $order['shipping_name']); ?>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-600">
                                        <?php echo date('M d, Y', strtotime($order['created_at'])); ?>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap font-semibold">
                                        <?php echo formatCurrency($order['total_amount']); ?>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <span class="badge <?php 
                                            echo match($order['status']) {
                                                'delivered' => 'bg-green-100 text-green-800',
                                                'shipped' => 'bg-blue-100 text-blue-800',
                                                'processing' => 'bg-yellow-100 text-yellow-800',
                                                'cancelled' => 'bg-red-100 text-red-800',
                                                default => 'bg-gray-100 text-gray-800'
                                            };
                                        ?>">
                                            <?php echo ucfirst($order['status']); ?>
                                        </span>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm">
                                        <button onclick="alert('Feature coming soon!')" class="text-primary-600 hover:text-primary-700">
                                            <i class="fas fa-eye mr-1"></i>View
                                        </button>
                                    </td>
                                </tr>
                            <?php endwhile; ?>
                        </tbody>
                    </table>
                </div>
            <?php else: ?>
                <div class="text-center py-8">
                    <i class="fas fa-shopping-bag text-gray-400 text-4xl mb-3"></i>
                    <p class="text-gray-600">No orders yet</p>
                </div>
            <?php endif; ?>
        </div>
    </div>
</section>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>
