# 🌐 Testing on skin.sifiso.online

## Your Domain Configuration

**Domain:** `skin.sifiso.online`  
**Type:** Subdomain  
**Protocol:** HTTPS (recommended)

## How It Works

Your site will automatically detect and use:
- **Site URL:** `https://skin.sifiso.online` (auto-detected)
- **CSS URL:** `https://skin.sifiso.online/assets/css/output.css`
- **Protocol:** HTTPS (if SSL is configured on your server)

No manual configuration needed! 🎉

---

## Step-by-Step Testing

### 1. First Upload (Initial Setup)

Upload these files to your server:
```
skin.sifiso.online/
├── assets/
├── config/
├── includes/
├── admin/
├── api/
├── uploads/
├── index.php
├── products.php
├── .htaccess
└── (all other .php files)
```

### 2. Update Database Credentials

Edit `config/database.php` on your server:
```php
define('DB_HOST', 'localhost'); // or your DB host
define('DB_USER', 'your_database_username');
define('DB_PASS', 'your_database_password');
define('DB_NAME', 'your_database_name');
```

### 3. Import Database

Using phpMyAdmin or command line:
```bash
mysql -u your_username -p your_database_name < database.sql
```

### 4. Run Configuration Check

Visit: **`https://skin.sifiso.online/check-config.php`**

Expected results:
```
✅ CSS File Check - Green (~31KB file found)
✅ Site URL Configuration - https://skin.sifiso.online
✅ Asset URL Generation - /assets/css/output.css
✅ Database Connection - Connected
✅ Uploads Directory - Writable
✅ Server Information - Shows your server details
```

### 5. Test Homepage

Visit: **`https://skin.sifiso.online`**

You should see:
- ✅ Full colorful design (green/purple theme)
- ✅ Styled navigation with logo
- ✅ Hero banner with products
- ✅ Product cards with images
- ✅ Beautiful footer
- ❌ NOT plain HTML with black text

### 6. Test All Pages

Check these URLs:
- **Homepage:** `https://skin.sifiso.online/index.php`
- **Products:** `https://skin.sifiso.online/products.php`
- **About:** `https://skin.sifiso.online/about.php`
- **Contact:** `https://skin.sifiso.online/contact.php`
- **Cart:** `https://skin.sifiso.online/cart.php`
- **Login:** `https://skin.sifiso.online/login.php`
- **Admin:** `https://skin.sifiso.online/admin/`

### 7. Test Admin Panel

Visit: **`https://skin.sifiso.online/admin/`**

Login with:
- **Email:** `admin@skincare.com`
- **Password:** `admin123`

⚠️ **IMPORTANT:** Change this password immediately after first login!

---

## Troubleshooting for Your Domain

### If You See Plain HTML (No Styles)

#### Check 1: Open Browser Console
1. Press **F12**
2. Go to **Console** tab
3. Look for errors like:
   ```
   Failed to load resource: https://skin.sifiso.online/assets/css/output.css
   ```

#### Check 2: Verify CSS File Was Uploaded
The file should be at:
```
/public_html/assets/css/output.css  (or wherever your site root is)
```

File size should be approximately **31KB**.

#### Check 3: Check File Permissions
```bash
chmod 644 assets/css/output.css
chmod 755 assets/css/
chmod 755 assets/
```

#### Check 4: Verify .htaccess Is Active
Visit a non-existent page:
```
https://skin.sifiso.online/test123
```
Should show your custom 404 page (not server default).

#### Check 5: Check Configuration Detection
Visit:
```
https://skin.sifiso.online/check-config.php
```
Verify "Site URL Configuration" shows your domain correctly.

---

## SSL/HTTPS Configuration

### If Using HTTPS (Recommended)

Your site will automatically detect HTTPS. No changes needed!

### To Force HTTPS

Edit `.htaccess` and uncomment lines 48-52:
```apache
<IfModule mod_rewrite.c>
    RewriteCond %{HTTPS} off
    RewriteCond %{HTTP_HOST} !^localhost [NC]
    RewriteRule ^(.*)$ https://%{HTTP_HOST}%{REQUEST_URI} [L,R=301]
</IfModule>
```

This will redirect all HTTP requests to HTTPS.

---

## Server-Specific Notes

### Common Hosting Providers

#### cPanel/Shared Hosting
- Upload to: `/public_html/` or `/www/`
- Database: Use phpMyAdmin
- File Manager: Use cPanel File Manager
- Permissions: Usually handled automatically

#### VPS/Dedicated Server
- Upload to: `/var/www/html/` or your configured web root
- Database: Use command line or phpMyAdmin
- File Manager: Use FTP/SFTP
- Permissions: Set manually (see above)

---

## Expected CSS Loading Path

When you visit `https://skin.sifiso.online`, the browser will load:

```html
<link rel="stylesheet" href="https://skin.sifiso.online/assets/css/output.css">
```

This is automatically generated by:
```php
<?php echo assetUrl('assets/css/output.css'); ?>
```

Which uses:
```php
SITE_URL = "https://skin.sifiso.online"  // Auto-detected
```

---

## Browser Testing Checklist

Test on different devices and browsers:

### Desktop
- [ ] Chrome - `https://skin.sifiso.online`
- [ ] Firefox - `https://skin.sifiso.online`
- [ ] Safari - `https://skin.sifiso.online`
- [ ] Edge - `https://skin.sifiso.online`

### Mobile
- [ ] iPhone Safari - Visit and check mobile menu
- [ ] Android Chrome - Test bottom navigation
- [ ] Tablet - Check responsive layout

---

## Performance Check

### Speed Test
Run these tests on your live site:
- **PageSpeed Insights:** https://pagespeed.web.dev/
- **GTmetrix:** https://gtmetrix.com/

Target metrics:
- **Load Time:** < 3 seconds
- **CSS Load:** Immediate
- **FCP (First Contentful Paint):** < 1.8s
- **LCP (Largest Contentful Paint):** < 2.5s

### Network Tab Check
1. Open DevTools (F12)
2. Go to Network tab
3. Reload page
4. Find `output.css` in the list
5. Check:
   - **Status:** 200 OK ✅
   - **Size:** ~31KB
   - **Time:** < 500ms
   - **URL:** `https://skin.sifiso.online/assets/css/output.css`

---

## Security Checklist for skin.sifiso.online

After deployment:

### Immediate (Before Going Live)
- [ ] Change admin password from `admin123`
- [ ] Set secure database password
- [ ] Enable HTTPS (SSL certificate)
- [ ] Test all forms for security
- [ ] Delete `check-config.php` file

### Recommended
- [ ] Enable firewall rules
- [ ] Set up automated backups
- [ ] Configure error logging (not display_errors)
- [ ] Add rate limiting for login attempts
- [ ] Set secure session settings
- [ ] Configure CSP headers

### Commands to Secure
```bash
# Delete diagnostic file after testing
rm check-config.php

# Set restrictive permissions
chmod 600 config/database.php
chmod 644 config/config.php
chmod 755 uploads/
chmod 755 uploads/products/
```

---

## Post-Deployment Success Indicators

✅ **Working Correctly When:**
- Homepage shows green/purple color scheme
- Products display in grid with images
- Navigation menu is styled
- Hover effects work
- Forms are styled
- Admin panel has dashboard layout
- Mobile bottom navigation appears on small screens

❌ **Problem If You See:**
- Black text on white background
- Times New Roman or serif fonts
- No images loading
- Plain bullet points
- No spacing or layout
- Browser console shows 404 for CSS

---

## Quick Debug Commands

### Check if CSS file exists on server
```bash
ls -lh assets/css/output.css
# Should show: -rw-r--r-- ... 31K ... output.css
```

### Check if .htaccess is being read
```bash
cat .htaccess | head -5
# Should show: # Enable rewrite engine
#              RewriteEngine On
```

### Test database connection
Visit: `https://skin.sifiso.online/check-config.php`

---

## Contact & Support

If you need to share diagnostic information:

1. **Screenshot of:** `https://skin.sifiso.online/check-config.php`
2. **Browser Console:** (F12 → Console tab)
3. **Network Tab:** (F12 → Network tab, filter: CSS)
4. **What you see vs what you expect**

---

## Success! 🎉

Once everything works:

1. **Delete diagnostic file:**
   ```bash
   rm check-config.php
   ```

2. **Bookmark your site:**
   - Homepage: `https://skin.sifiso.online`
   - Admin: `https://skin.sifiso.online/admin/`

3. **Share your site** - It's ready for customers!

---

**Your domain `skin.sifiso.online` is now configured for automatic detection!**

No manual SITE_URL updates needed - it just works! 🚀
