/** @type {import('tailwindcss').Config} */
module.exports = {
  content: [
    "./**/*.php",
    "./**/*.html",
    "./assets/**/*.js"
  ],
  theme: {
    extend: {
      colors: {
        primary: {
          50: '#fff8f6',
          100: '#ffece7',
          200: '#ffd8cf',
          300: '#ffc1b2',
          400: '#ffa895',
          500: '#ff8f78',
          600: '#f87563',
          700: '#e36053',
          800: '#c44d44',
          900: '#9f3d37',
        },
        accent: {
          50: '#fff7f9',
          100: '#ffe9f0',
          200: '#fecfe0',
          300: '#fcb6cf',
          400: '#f79ec0',
          500: '#ef85b0',
          600: '#db6a98',
          700: '#c25782',
          800: '#a04769',
          900: '#833a57',
        }
      },
      fontFamily: {
        sans: ['Inter', 'system-ui', 'sans-serif'],
        display: ['Playfair Display', 'serif'],
      },
      spacing: {
        '18': '4.5rem',
        '88': '22rem',
        '128': '32rem',
      },
      animation: {
        'fade-in': 'fadeIn 0.3s ease-in',
        'slide-up': 'slideUp 0.3s ease-out',
      },
      keyframes: {
        fadeIn: {
          '0%': { opacity: '0' },
          '100%': { opacity: '1' },
        },
        slideUp: {
          '0%': { transform: 'translateY(10px)', opacity: '0' },
          '100%': { transform: 'translateY(0)', opacity: '1' },
        },
      },
    },
  },
  plugins: [],
}
