<?php
require_once __DIR__ . '/config/config.php';

$pageTitle = "Home - Natural & Organic Skincare | " . SITE_NAME;
require_once 'includes/header.php';

$conn = getDBConnection();

// Get active hero banner
$heroBanner = $conn->query("SELECT * FROM hero_banners WHERE is_active = 1 ORDER BY display_order ASC LIMIT 1")->fetch_assoc();

// Get featured products
$featuredProducts = $conn->query("
    SELECT p.*, pi.image_url 
    FROM products p 
    LEFT JOIN product_images pi ON p.id = pi.product_id AND pi.is_primary = 1 
    WHERE p.featured = 1 AND p.status = 'active' 
    ORDER BY p.created_at DESC 
    LIMIT 8
");

// Get new arrivals
$newArrivals = $conn->query("
    SELECT p.*, pi.image_url 
    FROM products p 
    LEFT JOIN product_images pi ON p.id = pi.product_id AND pi.is_primary = 1 
    WHERE p.new_arrival = 1 AND p.status = 'active' 
    ORDER BY p.created_at DESC 
    LIMIT 12
");

// Get categories
$categories = $conn->query("SELECT * FROM categories ORDER BY display_order ASC LIMIT 6");
?>

<?php if ($heroBanner && $heroBanner['image_url']): ?>
<style>
    #hero-banner {
        background: linear-gradient(rgba(0,0,0,0.4), rgba(0,0,0,0.4)), url('<?php echo htmlspecialchars($heroBanner['image_url']); ?>');
        background-size: cover;
        background-position: <?php echo htmlspecialchars($heroBanner['bg_position_mobile'] ?? 'center'); ?>;
    }
    @media (min-width: 768px) {
        #hero-banner {
            background-position: <?php echo htmlspecialchars($heroBanner['bg_position_desktop'] ?? 'center'); ?>;
        }
    }
</style>
<?php endif; ?>

<!-- Hero Section -->
<section id="hero-banner" class="relative overflow-hidden" <?php if (!$heroBanner || !$heroBanner['image_url']): ?>style="background: linear-gradient(to bottom right, #fef6f3, #fedfd4);"<?php endif; ?>>
    <div class="container mx-auto px-4 py-20 md:py-32">
        <div class="grid md:grid-cols-2 gap-12 items-center">
            <div class="animate-fade-in">
                <h1 class="text-5xl md:text-6xl lg:text-7xl font-display font-bold mb-6 leading-tight <?php echo $heroBanner && $heroBanner['image_url'] ? 'text-white' : 'text-gray-900'; ?>">
                    <?php echo $heroBanner ? nl2br(htmlspecialchars($heroBanner['title'])) : 'Natural Beauty<br><span class="text-primary-600">Organic Care</span>'; ?>
                </h1>
                <?php if ($heroBanner && $heroBanner['subtitle']): ?>
                    <p class="text-xl mb-8 leading-relaxed <?php echo $heroBanner['image_url'] ? 'text-gray-100' : 'text-gray-600'; ?>">
                        <?php echo htmlspecialchars($heroBanner['subtitle']); ?>
                    </p>
                <?php else: ?>
                    <p class="text-xl text-gray-600 mb-8 leading-relaxed">
                        Discover the power of nature with our 100% organic skincare products. Eco-friendly, cruelty-free, and crafted for radiant skin.
                    </p>
                <?php endif; ?>
                <div class="flex flex-wrap gap-4">
                    <?php if ($heroBanner && $heroBanner['button_text']): ?>
                        <a href="<?php echo SITE_URL . htmlspecialchars($heroBanner['button_link'] ?: '/products.php'); ?>" class="btn-primary text-lg">
                            <?php echo htmlspecialchars($heroBanner['button_text']); ?> <i class="fas fa-arrow-right ml-2"></i>
                        </a>
                    <?php else: ?>
                        <a href="<?php echo SITE_URL; ?>/products.php" class="btn-primary text-lg">
                            Shop Now <i class="fas fa-arrow-right ml-2"></i>
                        </a>
                    <?php endif; ?>
                    <a href="<?php echo SITE_URL; ?>/about.php" class="btn-secondary text-lg">
                        Learn More
                    </a>
                </div>
                <div class="mt-12 flex items-center space-x-8 text-sm">
                    <div class="flex items-center">
                        <i class="fas fa-leaf text-2xl mr-3 <?php echo $heroBanner && $heroBanner['image_url'] ? 'text-white' : 'text-primary-600'; ?>"></i>
                        <span class="<?php echo $heroBanner && $heroBanner['image_url'] ? 'text-white' : 'text-gray-700'; ?>">100% Organic</span>
                    </div>
                    <div class="flex items-center">
                        <i class="fas fa-heart text-2xl mr-3 <?php echo $heroBanner && $heroBanner['image_url'] ? 'text-white' : 'text-primary-600'; ?>"></i>
                        <span class="<?php echo $heroBanner && $heroBanner['image_url'] ? 'text-white' : 'text-gray-700'; ?>">Cruelty-Free</span>
                    </div>
                    <div class="flex items-center">
                        <i class="fas fa-recycle text-2xl mr-3 <?php echo $heroBanner && $heroBanner['image_url'] ? 'text-white' : 'text-primary-600'; ?>"></i>
                        <span class="<?php echo $heroBanner && $heroBanner['image_url'] ? 'text-white' : 'text-gray-700'; ?>">Eco-Friendly</span>
                    </div>
                </div>
            </div>
            <div class="relative hidden md:block">
                <div class="relative z-10">
                    <?php 
                    $secondaryImageUrl = 'https://images.unsplash.com/photo-1522335789205-197f1c2b6a86?auto=format&fit=crop&w=800&q=80';
                    if ($heroBanner && !empty($heroBanner['secondary_image_url'])) {
                        $secondaryImageUrl = $heroBanner['secondary_image_url'];
                    }
                    ?>
                    <img src="<?php echo htmlspecialchars($secondaryImageUrl); ?>" 
                         alt="Skin Care collection" 
                         class="rounded-3xl shadow-2xl w-full object-cover">
                </div>
                <div class="absolute -bottom-10 -left-10 w-72 h-72 bg-primary-200 rounded-full opacity-50 blur-3xl"></div>
                <div class="absolute -top-10 -right-10 w-72 h-72 bg-accent-200 rounded-full opacity-50 blur-3xl"></div>
            </div>
        </div>
    </div>
</section>

<!-- Features -->
<section class="py-16 bg-white">
    <div class="container mx-auto px-4">
        <div class="grid md:grid-cols-3 gap-8">
            <div class="text-center">
                <div class="bg-primary-100 w-16 h-16 rounded-full flex items-center justify-center mx-auto mb-4">
                    <i class="fas fa-shipping-fast text-primary-600 text-2xl"></i>
                </div>
                <h3 class="font-display font-bold text-xl mb-2">Free Shipping</h3>
                <p class="text-gray-600">On orders over <?php echo formatCurrency(FREE_SHIPPING_THRESHOLD); ?></p>
            </div>
            <div class="text-center">
                <div class="bg-primary-100 w-16 h-16 rounded-full flex items-center justify-center mx-auto mb-4">
                    <i class="fas fa-seedling text-primary-600 text-2xl"></i>
                </div>
                <h3 class="font-display font-bold text-xl mb-2">Plant a Tree</h3>
                <p class="text-gray-600">With every product purchased</p>
            </div>
            <div class="text-center">
                <div class="bg-primary-100 w-16 h-16 rounded-full flex items-center justify-center mx-auto mb-4">
                    <i class="fas fa-award text-primary-600 text-2xl"></i>
                </div>
                <h3 class="font-display font-bold text-xl mb-2">Premium Quality</h3>
                <p class="text-gray-600">Spa-grade organic products</p>
            </div>
        </div>
    </div>
</section>

<!-- New Arrivals -->
<section class="py-16 bg-gray-50">
    <div class="container mx-auto px-4">
        <div class="text-center mb-12">
            <h2 class="text-4xl md:text-5xl font-display font-bold text-gray-900 mb-4">Just Landed</h2>
            <p class="text-xl text-gray-600">Discover our newest organic skincare arrivals</p>
        </div>

        <div class="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-6">
            <?php while ($product = $newArrivals->fetch_assoc()): 
                $productImage = getProductImage($product['image_url'], $product['id']);
                $productImageIsPlaceholder = isPlaceholderImage($productImage);
            ?>
                <div class="card product-card group">
                    <a href="<?php echo SITE_URL; ?>/product.php?slug=<?php echo $product['slug']; ?>" class="block">
                        <div class="relative overflow-hidden bg-gray-100 aspect-square">
                            <img src="<?php echo $productImage; ?>" 
                                 alt="<?php echo htmlspecialchars($product['name']); ?>"
                                 class="w-full h-full object-cover">
                            <?php if ($productImageIsPlaceholder): ?>
                                <div class="absolute inset-0 bg-gray-900/40 flex items-center justify-center">
                                    <span class="text-white text-xs font-semibold tracking-wide uppercase">Image coming soon</span>
                                </div>
                            <?php endif; ?>
                            <?php if ($product['new_arrival']): ?>
                                <span class="badge badge-new absolute top-2 left-2">New</span>
                            <?php endif; ?>
                            <?php if ($product['sale_price']): ?>
                                <span class="badge badge-sale absolute top-2 right-2">Sale</span>
                            <?php endif; ?>
                        </div>
                    </a>
                    <div class="p-4">
                        <a href="<?php echo SITE_URL; ?>/product.php?slug=<?php echo $product['slug']; ?>">
                            <h3 class="font-semibold text-gray-900 mb-2 line-clamp-2 group-hover:text-primary-600 transition">
                                <?php echo htmlspecialchars($product['name']); ?>
                            </h3>
                        </a>
                        <div class="flex items-center justify-between">
                            <div>
                                <?php if ($product['sale_price']): ?>
                                    <span class="text-lg font-bold text-primary-600">
                                        <?php echo formatCurrency($product['sale_price']); ?>
                                    </span>
                                    <span class="text-sm text-gray-500 line-through ml-2">
                                        <?php echo formatCurrency($product['price']); ?>
                                    </span>
                                <?php else: ?>
                                    <span class="text-lg font-bold text-gray-900">
                                        <?php echo formatCurrency($product['price']); ?>
                                    </span>
                                <?php endif; ?>
                            </div>
                        </div>
                        <button type="button"
                                class="btn-primary w-full mt-3 text-sm js-add-to-cart"
                                data-product-id="<?php echo $product['id']; ?>">
                            <i class="fas fa-shopping-bag mr-2"></i>Add to Cart
                        </button>
                    </div>
                </div>
            <?php endwhile; ?>
        </div>

        <div class="text-center mt-12">
            <a href="<?php echo SITE_URL; ?>/products.php" class="btn-outline">
                View All Products <i class="fas fa-arrow-right ml-2"></i>
            </a>
        </div>
    </div>
</section>

<!-- Shop by Category -->
<section class="py-16 bg-white">
    <div class="container mx-auto px-4">
        <div class="text-center mb-12">
            <h2 class="text-4xl md:text-5xl font-display font-bold text-gray-900 mb-4">Shop by Category</h2>
            <p class="text-xl text-gray-600">Find the perfect products for your skin type</p>
        </div>

        <div class="grid grid-cols-2 md:grid-cols-3 gap-6">
            <?php 
            $categories->data_seek(0);
            while ($category = $categories->fetch_assoc()): 
                $categoryImage = getCategoryImage($category['image'] ?? null, $category['slug']);
                $categoryImageIsPlaceholder = isPlaceholderImage($categoryImage);
            ?>
                <a href="<?php echo SITE_URL; ?>/products.php?category=<?php echo $category['slug']; ?>" 
                   class="group relative overflow-hidden rounded-2xl shadow-lg hover:shadow-2xl transition-all duration-300">
                    <div class="aspect-square bg-gradient-to-br from-primary-100 to-primary-200">
                        <img src="<?php echo $categoryImage; ?>" 
                             alt="<?php echo htmlspecialchars($category['name']); ?>"
                             class="w-full h-full object-cover opacity-80 group-hover:scale-110 transition-transform duration-500">
                        <?php if ($categoryImageIsPlaceholder): ?>
                            <div class="absolute inset-0 bg-gray-900/40 flex items-center justify-center">
                                <span class="text-white text-xs font-semibold tracking-wide uppercase">Image coming soon</span>
                            </div>
                        <?php endif; ?>
                    </div>
                    <div class="absolute inset-0 bg-gradient-to-t from-black/70 to-transparent flex items-end">
                        <div class="p-6 w-full">
                            <h3 class="text-white font-display font-bold text-2xl mb-2">
                                <?php echo htmlspecialchars($category['name']); ?>
                            </h3>
                            <p class="text-white/90 text-sm">
                                <?php echo htmlspecialchars($category['description'] ?? 'Explore products'); ?>
                            </p>
                        </div>
                    </div>
                </a>
            <?php endwhile; ?>
        </div>
    </div>
</section>

<!-- Why Choose Us -->
<section class="py-16 bg-primary-50">
    <div class="container mx-auto px-4">
        <div class="text-center mb-12">
            <h2 class="text-4xl md:text-5xl font-display font-bold text-gray-900 mb-4">Why Choose Us</h2>
            <p class="text-xl text-gray-600">Your skincare solution backed by nature</p>
        </div>

        <div class="grid md:grid-cols-2 lg:grid-cols-3 gap-8">
            <div class="bg-white p-8 rounded-2xl shadow-md">
                <div class="bg-primary-100 w-12 h-12 rounded-full flex items-center justify-center mb-4">
                    <i class="fas fa-leaf text-primary-600 text-xl"></i>
                </div>
                <h3 class="font-display font-bold text-xl mb-3">100% Organic Ingredients</h3>
                <p class="text-gray-600 leading-relaxed">
                    Crafted using certified organic ingredients, free from harsh chemicals or synthetic additives.
                </p>
            </div>

            <div class="bg-white p-8 rounded-2xl shadow-md">
                <div class="bg-primary-100 w-12 h-12 rounded-full flex items-center justify-center mb-4">
                    <i class="fas fa-spa text-primary-600 text-xl"></i>
                </div>
                <h3 class="font-display font-bold text-xl mb-3">Radiant, Healthy Skin</h3>
                <p class="text-gray-600 leading-relaxed">
                    Enriched with antioxidants and vitamins to restore your skin's natural glow with visible results.
                </p>
            </div>

            <div class="bg-white p-8 rounded-2xl shadow-md">
                <div class="bg-primary-100 w-12 h-12 rounded-full flex items-center justify-center mb-4">
                    <i class="fas fa-star text-primary-600 text-xl"></i>
                </div>
                <h3 class="font-display font-bold text-xl mb-3">Spa-Grade Quality</h3>
                <p class="text-gray-600 leading-relaxed">
                    Professional quality products trusted by skincare experts and spas worldwide.
                </p>
            </div>

            <div class="bg-white p-8 rounded-2xl shadow-md">
                <div class="bg-primary-100 w-12 h-12 rounded-full flex items-center justify-center mb-4">
                    <i class="fas fa-globe text-primary-600 text-xl"></i>
                </div>
                <h3 class="font-display font-bold text-xl mb-3">Eco-Friendly & Sustainable</h3>
                <p class="text-gray-600 leading-relaxed">
                    Eco-conscious packaging supporting sustainability and reforestation with every purchase.
                </p>
            </div>

            <div class="bg-white p-8 rounded-2xl shadow-md">
                <div class="bg-primary-100 w-12 h-12 rounded-full flex items-center justify-center mb-4">
                    <i class="fas fa-bullseye text-primary-600 text-xl"></i>
                </div>
                <h3 class="font-display font-bold text-xl mb-3">Targeted Solutions</h3>
                <p class="text-gray-600 leading-relaxed">
                    Wide range of products designed to target your unique skincare challenges effectively.
                </p>
            </div>

            <div class="bg-white p-8 rounded-2xl shadow-md">
                <div class="bg-primary-100 w-12 h-12 rounded-full flex items-center justify-center mb-4">
                    <i class="fas fa-heart text-primary-600 text-xl"></i>
                </div>
                <h3 class="font-display font-bold text-xl mb-3">Vegan & Cruelty-Free</h3>
                <p class="text-gray-600 leading-relaxed">
                    Proudly vegan and cruelty-free, ensuring ethical products never tested on animals.
                </p>
            </div>
        </div>
    </div>
</section>

<!-- Newsletter CTA -->
<section class="py-20 bg-gradient-to-r from-primary-600 to-primary-700">
    <div class="container mx-auto px-4 text-center">
        <div class="max-w-2xl mx-auto">
            <h2 class="text-4xl md:text-5xl font-display font-bold text-white mb-4">
                Get 15% Off Your First Order
            </h2>
            <p class="text-xl text-primary-50 mb-8">
                Subscribe to our newsletter and receive exclusive deals, skincare tips, and more!
            </p>
            <form action="<?php echo SITE_URL; ?>/subscribe.php" method="POST" class="flex flex-col md:flex-row gap-4 max-w-md mx-auto">
                <input type="email" name="email" placeholder="Enter your email" required
                       class="flex-1 px-6 py-4 rounded-lg focus:outline-none focus:ring-2 focus:ring-white">
                <button type="submit" class="bg-white text-primary-600 px-8 py-4 rounded-lg font-bold hover:bg-primary-50 transition">
                    Subscribe
                </button>
            </form>
        </div>
    </div>
</section>

<?php 
closeDBConnection($conn);
require_once 'includes/footer.php'; 
?>
