<?php
require_once __DIR__ . '/../config/config.php';

// Get cart count
$conn = getDBConnection();
$cartCount = 0;
if (isLoggedIn()) {
    $userId = getCurrentUserId();
    $stmt = $conn->prepare("SELECT SUM(quantity) as total FROM cart WHERE user_id = ?");
    $stmt->bind_param("i", $userId);
} else {
    $sessionId = getCartSessionId();
    $stmt = $conn->prepare("SELECT SUM(quantity) as total FROM cart WHERE session_id = ?");
    $stmt->bind_param("s", $sessionId);
}
$stmt->execute();
$result = $stmt->get_result();
$row = $result->fetch_assoc();
$cartCount = $row['total'] ?? 0;
$stmt->close();
closeDBConnection($conn);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, viewport-fit=cover">
    <meta name="description" content="Discover the best in natural and organic skincare. Shop cleansers, serums, moisturizers, and more.">
    <meta name="theme-color" content="#ff8f78">
    <title><?php echo $pageTitle ?? SITE_NAME; ?></title>
    <link rel="stylesheet" href="<?php echo assetUrl('assets/css/output.css'); ?>">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <script src="https://unpkg.com/lucide@latest"></script>
</head>
<body class="bg-gray-50">
    <!-- Desktop Header -->
    <header class="bg-white shadow-sm sticky top-0 z-40">
        <!-- Top Bar -->
        <div class="bg-primary-600 text-white py-2 text-sm">
            <div class="container mx-auto px-4 flex justify-between items-center">
                <div class="hidden md:block">
                    <p>🌱 Free shipping on orders over <?php echo formatCurrency(FREE_SHIPPING_THRESHOLD); ?> | Plant a tree with every product!</p>
                </div>
                <div class="flex items-center space-x-4 ml-auto">
                    <?php if (isLoggedIn()): ?>
                        <?php if (isAdmin()): ?>
                            <a href="<?php echo SITE_URL; ?>/admin/index.php" class="hover:text-primary-100">
                                <i class="fas fa-gauge mr-1"></i>
                                Admin
                            </a>
                        <?php endif; ?>
                        <a href="<?php echo SITE_URL; ?>/account.php" class="hover:text-primary-100">
                            <i class="fas fa-user mr-1"></i>
                            <?php echo sanitize($_SESSION['user_name'] ?? 'My Account'); ?>
                        </a>
                        <a href="<?php echo SITE_URL; ?>/logout.php" class="hover:text-primary-100">Logout</a>
                    <?php else: ?>
                        <a href="<?php echo SITE_URL; ?>/login.php" class="hover:text-primary-100">Login</a>
                        <a href="<?php echo SITE_URL; ?>/register.php" class="hover:text-primary-100">Register</a>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <!-- Main Navigation -->
        <nav class="container mx-auto px-4 py-4">
            <div class="flex items-center justify-between">
                <!-- Logo -->
                <a href="<?php echo SITE_URL; ?>/index.php" class="flex items-center space-x-2">
                    <div class="bg-primary-600 text-white rounded-full w-10 h-10 flex items-center justify-center font-bold text-xl">
                        🌿
                    </div>
                    <span class="text-2xl font-display font-bold text-primary-700"><?php echo SITE_NAME; ?></span>
                </a>

                <!-- Desktop Menu -->
                <div class="hidden md:flex items-center space-x-8">
                    <a href="<?php echo SITE_URL; ?>/index.php" class="text-gray-700 hover:text-primary-600 font-medium transition">Home</a>
                    <a href="<?php echo SITE_URL; ?>/products.php" class="text-gray-700 hover:text-primary-600 font-medium transition">Shop All</a>
                    <div class="relative group">
                        <button class="text-gray-700 hover:text-primary-600 font-medium transition flex items-center">
                            Categories <i class="fas fa-chevron-down ml-1 text-xs"></i>
                        </button>
                        <div class="absolute top-full left-0 mt-2 w-56 bg-white rounded-lg shadow-xl opacity-0 invisible group-hover:opacity-100 group-hover:visible transition-all duration-200">
                            <?php
                            $conn = getDBConnection();
                            $categories = $conn->query("SELECT * FROM categories ORDER BY display_order ASC");
                            while ($category = $categories->fetch_assoc()):
                            ?>
                                <a href="<?php echo SITE_URL; ?>/products.php?category=<?php echo $category['slug']; ?>" 
                                   class="block px-4 py-3 text-gray-700 hover:bg-primary-50 hover:text-primary-600 transition">
                                    <?php echo htmlspecialchars($category['name']); ?>
                                </a>
                            <?php endwhile; closeDBConnection($conn); ?>
                        </div>
                    </div>
                    <a href="<?php echo SITE_URL; ?>/about.php" class="text-gray-700 hover:text-primary-600 font-medium transition">About</a>
                    <a href="<?php echo SITE_URL; ?>/contact.php" class="text-gray-700 hover:text-primary-600 font-medium transition">Contact</a>
                </div>

                <!-- Right Actions -->
                <div class="hidden md:flex items-center space-x-4">
                    <button onclick="toggleSearch()" class="text-gray-700 hover:text-primary-600 transition">
                        <i class="fas fa-search text-xl"></i>
                    </button>
                    <a href="<?php echo SITE_URL; ?>/cart.php" class="text-gray-700 hover:text-primary-600 transition relative">
                        <i class="fas fa-shopping-bag text-xl"></i>
                        <span class="cart-badge <?php echo $cartCount > 0 ? '' : 'hidden'; ?>"><?php echo $cartCount > 0 ? $cartCount : '0'; ?></span>
                    </a>
                </div>

                <!-- Mobile Menu Toggle -->
                <button onclick="toggleMobileMenu()" class="md:hidden text-gray-700">
                    <i class="fas fa-bars text-2xl"></i>
                </button>
            </div>

            <!-- Search Bar (Hidden by default) -->
            <div id="searchBar" class="hidden mt-4">
                <form action="<?php echo SITE_URL; ?>/products.php" method="GET" class="flex">
                    <input type="text" name="search" placeholder="Search products..." class="input-field rounded-r-none">
                    <button type="submit" class="btn-primary rounded-l-none">
                        <i class="fas fa-search"></i>
                    </button>
                </form>
            </div>
        </nav>

        <!-- Mobile Menu (Hidden by default) -->
        <div id="mobileMenu" class="hidden md:hidden border-t border-gray-200 bg-white">
            <div class="container mx-auto px-4 py-4 space-y-2">
                <a href="<?php echo SITE_URL; ?>/index.php" class="block py-2 text-gray-700 hover:text-primary-600">Home</a>
                <a href="<?php echo SITE_URL; ?>/products.php" class="block py-2 text-gray-700 hover:text-primary-600">Shop All</a>
                <?php if (isLoggedIn() && isAdmin()): ?>
                    <a href="<?php echo SITE_URL; ?>/admin/index.php" class="block py-2 text-gray-700 hover:text-primary-600">Admin</a>
                <?php endif; ?>
                <div class="py-2">
                    <p class="font-semibold text-gray-900 mb-2">Categories</p>
                    <?php
                    $conn = getDBConnection();
                    $categories = $conn->query("SELECT * FROM categories ORDER BY display_order ASC");
                    while ($category = $categories->fetch_assoc()):
                    ?>
                        <a href="<?php echo SITE_URL; ?>/products.php?category=<?php echo $category['slug']; ?>" 
                           class="block py-2 pl-4 text-gray-600 hover:text-primary-600">
                            <?php echo htmlspecialchars($category['name']); ?>
                        </a>
                    <?php endwhile; closeDBConnection($conn); ?>
                </div>
                <a href="<?php echo SITE_URL; ?>/about.php" class="block py-2 text-gray-700 hover:text-primary-600">About</a>
                <a href="<?php echo SITE_URL; ?>/contact.php" class="block py-2 text-gray-700 hover:text-primary-600">Contact</a>
            </div>
        </div>
    </header>

    <script>
        function toggleSearch() {
            const searchBar = document.getElementById('searchBar');
            searchBar.classList.toggle('hidden');
        }

        function toggleMobileMenu() {
            const mobileMenu = document.getElementById('mobileMenu');
            mobileMenu.classList.toggle('hidden');
        }
    </script>
