    <!-- Footer -->
    <footer class="bg-gray-900 text-gray-300 mt-20 pb-20 md:pb-0">
        <div class="container mx-auto px-4 py-12">
            <div class="grid grid-cols-1 md:grid-cols-4 gap-8">
                <!-- About -->
                <div>
                    <h3 class="text-white font-display font-bold text-xl mb-4">
                        <?php echo SITE_NAME; ?>
                    </h3>
                    <p class="text-sm leading-relaxed mb-4">
                        Discover the best in natural and organic skincare. 100% organic ingredients, cruelty-free, and eco-friendly.
                    </p>
                    <div class="flex space-x-4">
                        <a href="#" class="text-gray-400 hover:text-white transition">
                            <i class="fab fa-facebook-f text-xl"></i>
                        </a>
                        <a href="#" class="text-gray-400 hover:text-white transition">
                            <i class="fab fa-instagram text-xl"></i>
                        </a>
                        <a href="#" class="text-gray-400 hover:text-white transition">
                            <i class="fab fa-twitter text-xl"></i>
                        </a>
                        <a href="#" class="text-gray-400 hover:text-white transition">
                            <i class="fab fa-pinterest text-xl"></i>
                        </a>
                    </div>
                </div>

                <!-- Quick Links -->
                <div>
                    <h4 class="text-white font-semibold mb-4">Quick Links</h4>
                    <ul class="space-y-2 text-sm">
                        <li><a href="<?php echo SITE_URL; ?>/about.php" class="hover:text-white transition">About Us</a></li>
                        <li><a href="<?php echo SITE_URL; ?>/products.php" class="hover:text-white transition">Shop All Products</a></li>
                        <li><a href="<?php echo SITE_URL; ?>/contact.php" class="hover:text-white transition">Contact Us</a></li>
                        <li><a href="<?php echo SITE_URL; ?>/faq.php" class="hover:text-white transition">FAQ</a></li>
                        <li><a href="<?php echo SITE_URL; ?>/shipping.php" class="hover:text-white transition">Shipping Policy</a></li>
                    </ul>
                </div>

                <!-- Customer Service -->
                <div>
                    <h4 class="text-white font-semibold mb-4">Customer Service</h4>
                    <ul class="space-y-2 text-sm">
                        <li><a href="<?php echo SITE_URL; ?>/account.php" class="hover:text-white transition">My Account</a></li>
                        <li><a href="<?php echo SITE_URL; ?>/orders.php" class="hover:text-white transition">Order History</a></li>
                        <li><a href="<?php echo SITE_URL; ?>/returns.php" class="hover:text-white transition">Returns</a></li>
                        <li><a href="<?php echo SITE_URL; ?>/terms.php" class="hover:text-white transition">Terms & Conditions</a></li>
                        <li><a href="<?php echo SITE_URL; ?>/privacy.php" class="hover:text-white transition">Privacy Policy</a></li>
                    </ul>
                </div>

                <!-- Newsletter -->
                <div>
                    <h4 class="text-white font-semibold mb-4">Newsletter</h4>
                    <p class="text-sm mb-4">Subscribe to receive updates, access to exclusive deals, and more.</p>
                    <form action="<?php echo SITE_URL; ?>/subscribe.php" method="POST" class="space-y-2">
                        <input type="email" name="email" placeholder="Your email" required 
                               class="w-full px-4 py-2 rounded-lg bg-gray-800 border border-gray-700 focus:outline-none focus:ring-2 focus:ring-primary-500 text-white">
                        <button type="submit" class="w-full btn-primary">
                            Subscribe
                        </button>
                    </form>
                </div>
            </div>

            <div class="border-t border-gray-800 mt-8 pt-8 text-center text-sm">
                <p>&copy; <?php echo date('Y'); ?> <?php echo SITE_NAME; ?>. All rights reserved. | Crafted with 💚 for beautiful skin</p>
            </div>
        </div>
    </footer>

    <!-- Mobile Bottom Navigation -->
    <div class="bottom-nav">
        <div class="flex justify-around items-center py-3">
            <a href="<?php echo SITE_URL; ?>/index.php" class="mobile-menu-item <?php echo basename($_SERVER['PHP_SELF']) == 'index.php' ? 'active' : ''; ?>">
                <i data-lucide="home" class="mobile-menu-icon"></i>
                <span>Home</span>
            </a>
            <a href="<?php echo SITE_URL; ?>/products.php" class="mobile-menu-item <?php echo basename($_SERVER['PHP_SELF']) == 'products.php' ? 'active' : ''; ?>">
                <i data-lucide="grid-2x2" class="mobile-menu-icon"></i>
                <span>Shop</span>
            </a>
            <a href="<?php echo SITE_URL; ?>/cart.php" class="mobile-menu-item relative <?php echo basename($_SERVER['PHP_SELF']) == 'cart.php' ? 'active' : ''; ?>">
                <div class="relative">
                    <i data-lucide="shopping-bag" class="mobile-menu-icon"></i>
                    <span class="cart-badge <?php echo $cartCount > 0 ? '' : 'hidden'; ?>">
                        <?php echo $cartCount > 0 ? $cartCount : '0'; ?>
                    </span>
                </div>
                <span>Cart</span>
            </a>
            <a href="<?php echo SITE_URL; ?>/wishlist.php" class="mobile-menu-item <?php echo basename($_SERVER['PHP_SELF']) == 'wishlist.php' ? 'active' : ''; ?>">
                <i data-lucide="heart" class="mobile-menu-icon"></i>
                <span>Wishlist</span>
            </a>
            <a href="<?php echo SITE_URL; ?>/account.php" class="mobile-menu-item <?php echo basename($_SERVER['PHP_SELF']) == 'account.php' ? 'active' : ''; ?>">
                <i data-lucide="user" class="mobile-menu-icon"></i>
                <span>Account</span>
            </a>
        </div>
    </div>

    <!-- Back to Top Button -->
    <button onclick="scrollToTop()" id="backToTop" class="fixed bottom-24 md:bottom-8 right-4 bg-primary-600 text-white p-3 rounded-full shadow-lg hover:bg-primary-700 transition-all duration-300 opacity-0 invisible">
        <i data-lucide="arrow-up" class="w-5 h-5"></i>
    </button>

    <script>
        // Back to top functionality
        window.addEventListener('scroll', function() {
            const backToTop = document.getElementById('backToTop');
            if (window.pageYOffset > 300) {
                backToTop.classList.remove('opacity-0', 'invisible');
            } else {
                backToTop.classList.add('opacity-0', 'invisible');
            }
        });

        function scrollToTop() {
            window.scrollTo({ top: 0, behavior: 'smooth' });
        }

        function updateCartCount() {
            fetch('<?php echo SITE_URL; ?>/api/cart-count.php')
                .then(response => response.json())
                .then(data => {
                    const badges = document.querySelectorAll('.cart-badge');
                    badges.forEach(badge => {
                        if (data.count > 0) {
                            badge.textContent = data.count;
                            badge.classList.remove('hidden');
                        } else {
                            badge.classList.add('hidden');
                        }
                    });
                });
        }

        function attachCartHandlers() {
            const buttons = document.querySelectorAll('.js-add-to-cart');

            const handleClick = (event) => {
                event.preventDefault();
                const button = event.currentTarget;
                const productId = parseInt(button.dataset.productId, 10);
                if (!productId) {
                    return;
                }

                let quantity = 1;
                const quantityInputId = button.dataset.quantityInput;
                if (quantityInputId) {
                    const quantityInput = document.getElementById(quantityInputId);
                    if (quantityInput) {
                        const parsedQty = parseInt(quantityInput.value, 10);
                        if (!Number.isNaN(parsedQty) && parsedQty > 0) {
                            quantity = parsedQty;
                        }
                    }
                }

                const originalText = button.innerHTML;
                button.disabled = true;
                button.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Adding...';

                fetch('<?php echo SITE_URL; ?>/api/add-to-cart.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                    },
                    body: JSON.stringify({ product_id: productId, quantity })
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        button.innerHTML = '<i class="fas fa-check"></i> Added!';
                        button.classList.add('bg-green-600');
                        updateCartCount();

                        setTimeout(() => {
                            button.innerHTML = originalText;
                            button.classList.remove('bg-green-600');
                            button.disabled = false;
                        }, 1500);
                    } else {
                        throw new Error(data.message || 'Failed to add to cart');
                    }
                })
                .catch(error => {
                    console.error(error);
                    button.innerHTML = originalText;
                    button.disabled = false;
                    alert('Could not add to cart. Please try again.');
                });
            };

            buttons.forEach(button => {
                button.removeEventListener('click', handleClick);
                button.addEventListener('click', handleClick);
            });
        }

        document.addEventListener('DOMContentLoaded', attachCartHandlers);
        document.addEventListener('shop:cart-buttons-refresh', attachCartHandlers);

        // Initialize Lucide icons
        if (typeof lucide !== 'undefined') {
            lucide.createIcons();
        }
    </script>
</body>
</html>
