<?php
require_once 'config/config.php';
$pageTitle = "Contact Us | " . SITE_NAME;
require_once 'includes/header.php';
?>

<section class="py-20 min-h-screen bg-gray-50">
    <div class="container mx-auto px-4">
        <div class="text-center mb-12">
            <h1 class="text-4xl md:text-5xl font-display font-bold text-gray-900 mb-4">Get In Touch</h1>
            <p class="text-xl text-gray-600">We'd love to hear from you</p>
        </div>

        <div class="grid md:grid-cols-2 gap-12 max-w-6xl mx-auto">
            <!-- Contact Form -->
            <div class="bg-white rounded-2xl shadow-xl p-8">
                <h2 class="text-2xl font-display font-bold text-gray-900 mb-6">Send Us a Message</h2>
                
                <form action="#" method="POST">
                    <div class="mb-4">
                        <label class="block text-gray-700 font-semibold mb-2">Name</label>
                        <input type="text" name="name" required class="input-field" placeholder="Your name">
                    </div>

                    <div class="mb-4">
                        <label class="block text-gray-700 font-semibold mb-2">Email</label>
                        <input type="email" name="email" required class="input-field" placeholder="your@email.com">
                    </div>

                    <div class="mb-4">
                        <label class="block text-gray-700 font-semibold mb-2">Subject</label>
                        <input type="text" name="subject" required class="input-field" placeholder="How can we help?">
                    </div>

                    <div class="mb-6">
                        <label class="block text-gray-700 font-semibold mb-2">Message</label>
                        <textarea name="message" rows="5" required class="input-field" 
                                  placeholder="Your message..."></textarea>
                    </div>

                    <button type="submit" class="btn-primary w-full text-lg">
                        <i class="fas fa-paper-plane mr-2"></i>Send Message
                    </button>
                </form>
            </div>

            <!-- Contact Info -->
            <div>
                <div class="bg-white rounded-2xl shadow-xl p-8 mb-6">
                    <h2 class="text-2xl font-display font-bold text-gray-900 mb-6">Contact Information</h2>
                    
                    <div class="space-y-6">
                        <div class="flex items-start">
                            <div class="bg-primary-100 w-12 h-12 rounded-full flex items-center justify-center mr-4 flex-shrink-0">
                                <i class="fas fa-map-marker-alt text-primary-600"></i>
                            </div>
                            <div>
                                <h3 class="font-semibold text-gray-900 mb-1">Address</h3>
                                <p class="text-gray-600">123 Beauty Street, Cape Town, 8001, South Africa</p>
                            </div>
                        </div>

                        <div class="flex items-start">
                            <div class="bg-primary-100 w-12 h-12 rounded-full flex items-center justify-center mr-4 flex-shrink-0">
                                <i class="fas fa-phone text-primary-600"></i>
                            </div>
                            <div>
                                <h3 class="font-semibold text-gray-900 mb-1">Phone</h3>
                                <p class="text-gray-600">+27 21 123 4567</p>
                            </div>
                        </div>

                        <div class="flex items-start">
                            <div class="bg-primary-100 w-12 h-12 rounded-full flex items-center justify-center mr-4 flex-shrink-0">
                                <i class="fas fa-envelope text-primary-600"></i>
                            </div>
                            <div>
                                <h3 class="font-semibold text-gray-900 mb-1">Email</h3>
                                <p class="text-gray-600">info@organicskincare.co.za</p>
                            </div>
                        </div>

                        <div class="flex items-start">
                            <div class="bg-primary-100 w-12 h-12 rounded-full flex items-center justify-center mr-4 flex-shrink-0">
                                <i class="fas fa-clock text-primary-600"></i>
                            </div>
                            <div>
                                <h3 class="font-semibold text-gray-900 mb-1">Business Hours</h3>
                                <p class="text-gray-600">Monday - Friday: 9:00 AM - 6:00 PM<br>Saturday: 10:00 AM - 4:00 PM</p>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="bg-primary-600 text-white rounded-2xl shadow-xl p-8">
                    <h3 class="text-2xl font-display font-bold mb-4">Need Quick Help?</h3>
                    <p class="mb-6">Check out our FAQ section for instant answers to common questions.</p>
                    <a href="#" class="btn-secondary w-full">
                        Visit FAQ
                    </a>
                </div>
            </div>
        </div>
    </div>
</section>

<?php require_once 'includes/footer.php'; ?>
