<?php
require_once __DIR__ . '/../config/config.php';

header('Content-Type: application/json');

$conn = getDBConnection();

$cartCount = 0;
if (isLoggedIn()) {
    $userId = getCurrentUserId();
    $stmt = $conn->prepare("SELECT SUM(quantity) as total FROM cart WHERE user_id = ?");
    $stmt->bind_param("i", $userId);
} else {
    $sessionId = getCartSessionId();
    $stmt = $conn->prepare("SELECT SUM(quantity) as total FROM cart WHERE session_id = ?");
    $stmt->bind_param("s", $sessionId);
}

$stmt->execute();
$result = $stmt->get_result();
$row = $result->fetch_assoc();
$cartCount = $row['total'] ?? 0;
$stmt->close();
closeDBConnection($conn);

echo json_encode(['count' => intval($cartCount)]);
