<?php
require_once __DIR__ . '/../config/config.php';

if (!isLoggedIn()) {
    $_SESSION['admin_redirect'] = true;
    redirect(SITE_URL . '/login.php?redirect=admin');
} elseif (!isAdmin()) {
    redirect(SITE_URL . '/index.php');
}

$activePage = 'customers';
$pageTitle = 'Customers | ' . SITE_NAME;

$conn = getDBConnection();

$search = trim($_GET['search'] ?? '');

$query = "SELECT * FROM users WHERE role = 'customer'";
$params = [];
$types = '';

if ($search) {
    $query .= " AND (name LIKE ? OR email LIKE ? OR phone LIKE ?)";
    $like = '%' . $search . '%';
    $params = [$like, $like, $like];
    $types = 'sss';
}

$query .= " ORDER BY created_at DESC";
$stmt = $conn->prepare($query);
if ($params) {
    $stmt->bind_param($types, ...$params);
}
$stmt->execute();
$customers = $stmt->get_result();

require_once __DIR__ . '/../includes/header.php';
require_once __DIR__ . '/admin_nav.php';
?>

<div class="container mx-auto px-4 pb-12">
    <div class="bg-white rounded-xl shadow-md border border-gray-200">
        <div class="flex flex-col md:flex-row md:items-center md:justify-between p-6 border-b border-gray-200 gap-4">
            <div>
                <h1 class="text-2xl font-display font-bold text-gray-900">Customers</h1>
                <p class="text-sm text-gray-500">View and manage your registered customers.</p>
            </div>
            <form method="GET" class="flex items-center gap-3">
                <input type="text" name="search" class="input-field" placeholder="Search customers" value="<?php echo htmlspecialchars($search); ?>">
                <button type="submit" class="btn-outline text-sm">Search</button>
            </form>
        </div>

        <div class="overflow-x-auto">
            <table class="w-full text-sm">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-4 py-3 text-left font-semibold text-gray-600">Customer</th>
                        <th class="px-4 py-3 text-left font-semibold text-gray-600">Contact</th>
                        <th class="px-4 py-3 text-left font-semibold text-gray-600">Location</th>
                        <th class="px-4 py-3 text-left font-semibold text-gray-600">Joined</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-100">
                    <?php if ($customers->num_rows > 0): ?>
                        <?php while ($customer = $customers->fetch_assoc()): ?>
                            <tr class="hover:bg-gray-50">
                                <td class="px-4 py-3">
                                    <div class="font-semibold text-gray-900"><?php echo htmlspecialchars($customer['name']); ?></div>
                                    <div class="text-xs text-gray-500">#<?php echo $customer['id']; ?></div>
                                </td>
                                <td class="px-4 py-3 text-gray-600">
                                    <div><?php echo htmlspecialchars($customer['email']); ?></div>
                                    <?php if ($customer['phone']): ?>
                                        <div class="text-xs text-gray-500"><?php echo htmlspecialchars($customer['phone']); ?></div>
                                    <?php endif; ?>
                                </td>
                                <td class="px-4 py-3 text-gray-600">
                                    <div><?php echo htmlspecialchars($customer['city'] ?: '—'); ?></div>
                                    <?php if ($customer['postal_code']): ?>
                                        <div class="text-xs text-gray-500"><?php echo htmlspecialchars($customer['postal_code']); ?></div>
                                    <?php endif; ?>
                                </td>
                                <td class="px-4 py-3 text-gray-600">
                                    <?php echo date('M d, Y', strtotime($customer['created_at'])); ?>
                                </td>
                            </tr>
                        <?php endwhile; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="4" class="text-center text-gray-500 py-6">No customers found.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php
$customers->free();
closeDBConnection($conn);
require_once __DIR__ . '/../includes/footer.php';
?>
