<?php
require_once 'config/config.php';

if (!isLoggedIn()) {
    redirect(SITE_URL . '/login.php');
}

$pageTitle = "My Account | " . SITE_NAME;
require_once 'includes/header.php';

$conn = getDBConnection();
$userId = getCurrentUserId();

// Get user info
$stmt = $conn->prepare("SELECT * FROM users WHERE id = ?");
$stmt->bind_param("i", $userId);
$stmt->execute();
$user = $stmt->get_result()->fetch_assoc();
$stmt->close();

// Get recent orders
$ordersStmt = $conn->prepare("
    SELECT * FROM orders 
    WHERE user_id = ? 
    ORDER BY created_at DESC 
    LIMIT 5
");
$ordersStmt->bind_param("i", $userId);
$ordersStmt->execute();
$orders = $ordersStmt->get_result();
$ordersStmt->close();

closeDBConnection($conn);
?>

<section class="py-12 min-h-screen bg-gray-50">
    <div class="container mx-auto px-4">
        <h1 class="text-4xl font-display font-bold text-gray-900 mb-8">My Account</h1>

        <div class="grid md:grid-cols-3 gap-8">
            <!-- Sidebar -->
            <aside class="md:col-span-1">
                <div class="bg-white rounded-xl shadow-md p-6">
                    <div class="text-center mb-6">
                        <div class="w-20 h-20 bg-primary-100 rounded-full flex items-center justify-center mx-auto mb-3">
                            <i class="fas fa-user text-primary-600 text-3xl"></i>
                        </div>
                        <h2 class="font-display font-bold text-xl text-gray-900"><?php echo htmlspecialchars($user['name']); ?></h2>
                        <p class="text-gray-600 text-sm"><?php echo htmlspecialchars($user['email']); ?></p>
                    </div>

                    <nav class="space-y-2">
                        <a href="#" class="block px-4 py-3 bg-primary-50 text-primary-700 rounded-lg font-medium">
                            <i class="fas fa-user mr-2"></i>Profile
                        </a>
                        <a href="<?php echo SITE_URL; ?>/orders.php" class="block px-4 py-3 text-gray-700 hover:bg-gray-50 rounded-lg">
                            <i class="fas fa-shopping-bag mr-2"></i>Orders
                        </a>
                        <a href="<?php echo SITE_URL; ?>/wishlist.php" class="block px-4 py-3 text-gray-700 hover:bg-gray-50 rounded-lg">
                            <i class="fas fa-heart mr-2"></i>Wishlist
                        </a>
                        <a href="<?php echo SITE_URL; ?>/logout.php" class="block px-4 py-3 text-red-600 hover:bg-red-50 rounded-lg">
                            <i class="fas fa-sign-out-alt mr-2"></i>Logout
                        </a>
                    </nav>
                </div>
            </aside>

            <!-- Main Content -->
            <div class="md:col-span-2">
                <!-- Account Details -->
                <div class="bg-white rounded-xl shadow-md p-6 mb-6">
                    <h2 class="text-2xl font-display font-bold text-gray-900 mb-6">Account Details</h2>
                    
                    <div class="grid md:grid-cols-2 gap-6">
                        <div>
                            <label class="block text-sm font-semibold text-gray-700 mb-2">Full Name</label>
                            <p class="text-gray-900"><?php echo htmlspecialchars($user['name']); ?></p>
                        </div>
                        <div>
                            <label class="block text-sm font-semibold text-gray-700 mb-2">Email</label>
                            <p class="text-gray-900"><?php echo htmlspecialchars($user['email']); ?></p>
                        </div>
                        <div>
                            <label class="block text-sm font-semibold text-gray-700 mb-2">Phone</label>
                            <p class="text-gray-900"><?php echo htmlspecialchars($user['phone'] ?? 'Not provided'); ?></p>
                        </div>
                        <div>
                            <label class="block text-sm font-semibold text-gray-700 mb-2">Member Since</label>
                            <p class="text-gray-900"><?php echo date('F Y', strtotime($user['created_at'])); ?></p>
                        </div>
                    </div>

                    <div class="mt-6">
                        <button class="btn-primary">
                            <i class="fas fa-edit mr-2"></i>Edit Profile
                        </button>
                    </div>
                </div>

                <!-- Recent Orders -->
                <div class="bg-white rounded-xl shadow-md p-6">
                    <div class="flex justify-between items-center mb-6">
                        <h2 class="text-2xl font-display font-bold text-gray-900">Recent Orders</h2>
                        <a href="<?php echo SITE_URL; ?>/orders.php" class="text-primary-600 hover:text-primary-700 font-semibold">
                            View All
                        </a>
                    </div>

                    <?php if ($orders->num_rows > 0): ?>
                        <div class="space-y-4">
                            <?php while ($order = $orders->fetch_assoc()): ?>
                                <div class="border border-gray-200 rounded-lg p-4 hover:border-primary-300 transition">
                                    <div class="flex justify-between items-start mb-2">
                                        <div>
                                            <p class="font-semibold text-gray-900">Order #<?php echo $order['order_number']; ?></p>
                                            <p class="text-sm text-gray-600"><?php echo date('F d, Y', strtotime($order['created_at'])); ?></p>
                                        </div>
                                        <span class="badge <?php 
                                            echo match($order['status']) {
                                                'delivered' => 'bg-green-100 text-green-800',
                                                'shipped' => 'bg-blue-100 text-blue-800',
                                                'processing' => 'bg-yellow-100 text-yellow-800',
                                                'cancelled' => 'bg-red-100 text-red-800',
                                                default => 'bg-gray-100 text-gray-800'
                                            };
                                        ?>">
                                            <?php echo ucfirst($order['status']); ?>
                                        </span>
                                    </div>
                                    <div class="flex justify-between items-center">
                                        <p class="text-lg font-bold text-primary-600">
                                            <?php echo formatCurrency($order['total_amount']); ?>
                                        </p>
                                        <a href="<?php echo SITE_URL; ?>/order-details.php?id=<?php echo $order['id']; ?>" 
                                           class="text-sm text-primary-600 hover:text-primary-700 font-semibold">
                                            View Details <i class="fas fa-arrow-right ml-1"></i>
                                        </a>
                                    </div>
                                </div>
                            <?php endwhile; ?>
                        </div>
                    <?php else: ?>
                        <div class="text-center py-8">
                            <i class="fas fa-shopping-bag text-gray-400 text-4xl mb-3"></i>
                            <p class="text-gray-600">No orders yet</p>
                            <a href="<?php echo SITE_URL; ?>/products.php" class="btn-primary mt-4">
                                Start Shopping
                            </a>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</section>

<?php require_once 'includes/footer.php'; ?>
