# 🧪 Quick Test Guide

## Test Locally (XAMPP)

### 1. Check Configuration
Visit: `http://localhost/skin/check-config.php`

Expected results:
- ✅ CSS File Check - Green (should show ~31KB)
- ✅ Site URL Configuration - Shows `http://localhost/skin`
- ✅ Asset URL Generation - Working
- ✅ Database Connection - Connected
- ✅ Uploads Directory - Writable

### 2. Test Homepage
Visit: `http://localhost/skin/index.php`

Check:
- [ ] Styles are loading (colorful design, not plain HTML)
- [ ] Navigation menu looks good
- [ ] Product cards are styled
- [ ] Footer is visible

### 3. Test Products Page
Visit: `http://localhost/skin/products.php`

Check:
- [ ] Product grid displays correctly
- [ ] Filter buttons are styled
- [ ] Hover effects work
- [ ] Images load properly

### 4. Test Admin Panel
Visit: `http://localhost/skin/admin/`

Login with:
- Email: `admin@skincare.com`
- Password: `admin123`

Check:
- [ ] Admin dashboard loads with styles
- [ ] Statistics cards display correctly
- [ ] Navigation works

---

## Test Online (Production)

### 1. Deploy Files
Upload all files to your production server.

### 2. Update Database Config
Edit `config/database.php`:
```php
define('DB_HOST', 'your_production_host');
define('DB_USER', 'your_production_user');
define('DB_PASS', 'your_production_password');
define('DB_NAME', 'your_production_database');
```

### 3. Import Database
Import `database.sql` to your production database.

### 4. Check Configuration
Visit: `https://yourdomain.com/check-config.php`

Expected results:
- ✅ CSS File Check - Green
- ✅ Site URL Configuration - Shows `https://yourdomain.com`
- ✅ Protocol shows HTTPS
- ✅ Database Connection - Connected
- ✅ All checks green

### 5. Test Main Site
Visit: `https://yourdomain.com`

Check:
- [ ] Full design loads (not just HTML)
- [ ] Navigation works
- [ ] All pages have styles
- [ ] Images load
- [ ] Admin panel accessible

### 6. Security Cleanup
After testing, delete diagnostic file:
```bash
rm check-config.php
```

Or restrict access in `.htaccess`:
```apache
<Files "check-config.php">
    Order allow,deny
    Deny from all
</Files>
```

---

## Common Issues & Quick Fixes

### Issue: Still Seeing Plain HTML Online

**Check 1: CSS File Size**
```bash
ls -lh assets/css/output.css
```
Should show ~31KB. If not:
```bash
npm run build:css
```

**Check 2: File Permissions**
```bash
chmod 644 assets/css/output.css
chmod 755 assets/css/
```

**Check 3: Browser Console**
- Press F12
- Go to Console tab
- Look for 404 errors on CSS file
- Note the URL it's trying to load

**Check 4: .htaccess Working**
Test by visiting: `https://yourdomain.com/nonexistent-page`
Should show your custom 404 page (not server default).

### Issue: Database Connection Failed

**Fix:**
1. Verify credentials in `config/database.php`
2. Test connection via phpMyAdmin
3. Check database user has proper permissions
4. Ensure database exists

### Issue: Admin Panel Not Loading

**Fix:**
1. Clear browser cache
2. Check if logged in
3. Verify admin user exists in database
4. Check session support is enabled in PHP

---

## Browser Testing

Test on multiple browsers:
- [ ] Chrome/Edge
- [ ] Firefox
- [ ] Safari (if on Mac)
- [ ] Mobile browser

Test on mobile devices:
- [ ] iPhone/iOS
- [ ] Android
- [ ] Tablet

---

## Performance Check

### Speed Test
Use tools like:
- Google PageSpeed Insights
- GTmetrix
- Pingdom

Expected performance:
- Load time: < 3 seconds
- CSS loads immediately
- Images lazy load

### Browser DevTools Network Tab
1. Press F12
2. Go to Network tab
3. Reload page
4. Check:
   - `output.css` loads successfully (Status: 200)
   - Size: ~31KB
   - Time: < 500ms

---

## Final Checklist

### Local (XAMPP)
- [ ] `check-config.php` all green
- [ ] Homepage loads with styles
- [ ] Products page works
- [ ] Cart functionality works
- [ ] Admin panel accessible
- [ ] Database operations work

### Production
- [ ] Database imported successfully
- [ ] `config/database.php` updated
- [ ] `check-config.php` shows production URL
- [ ] HTTPS working (if applicable)
- [ ] All pages load with full styling
- [ ] Forms work (login, register, etc.)
- [ ] Cart operations work
- [ ] Admin panel accessible
- [ ] `check-config.php` deleted/restricted

---

## Need Help?

### Diagnostic Information to Collect:

1. **From `check-config.php`:**
   - Site URL value
   - CSS file status
   - Database connection status

2. **From Browser Console (F12):**
   - Any red errors
   - CSS file URL being loaded
   - HTTP status codes

3. **From Server:**
   - PHP version
   - Server software (Apache/Nginx)
   - Error logs location

4. **Screenshots:**
   - What you see (plain HTML)
   - What you expect (styled page)
   - Browser console errors

---

## Success Indicators

✅ You'll know it's working when:
- Homepage shows colorful, modern design
- Green color scheme visible
- Product cards have images and styling
- Navigation menu is styled
- Footer displays correctly
- Admin panel has dashboard layout
- All interactive elements work

❌ Signs of problems:
- Only seeing basic black text on white
- No colors or styling
- Times New Roman or default serif font
- No layout structure
- Missing images (404s in console)

---

**🎉 If all checks pass, your site is production-ready!**
